## -*-Tcl-*-
 # ==========================================================================
 #  WWW Menu - an extension package for Alpha
 # 
 #  FILE: "wwwMode.tcl"
 #                                    created: 04/30/1997 {11:04:46 am} 
 #                                last update: 11/07/2001 {10:27:43 AM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #     
 #  Description:
 #  
 #  The WWW Menu provides a simple text based (Lynx-like) HTML file
 #  browser, for reading local HTML files
 # 
 #  The reason to create a "WWW" mode is so that rendered windows can
 #  have easy access to the menu, and appropriate keybindings.
 # 
 #  See the "wwwVersionHistory.tcl" file for license info, credits, etc.
 # ==========================================================================
 ##

alpha::mode WWW {for wwwMenu menu} {wwwMode.tcl} {} {
    wwwMenu
} {
    # This requires AlphaTcl 7.5a3.
    alpha::package require -loose AlphaTcl 7.5a3
    set "newDocTypes(New WWW Browser)" WWW::renderUrl
    set "htmlViewer(Text-only parser)" WWW::renderFile
    if {[info tclversion] >= 8.0} {
	set "urlViewer(Internal text-only viewer)" WWW::renderUrl
    }
}

proc wwwMode.tcl {} {}

namespace eval WWW {}

# As of this writing, neither Alpha7 nor Alpha8 can handle the downloading
# of urls, so we disable that 'View Url' and associated menu items.  I
# believe that the problem lies in 'httpFetch', and that if the proper
# AppleEvent could be built then we would have this capability.
# 
# To debug this, add this line
# 
# set WWW::NoUrls 0
# 
# beneath the if/else below, evaluate this file, and then use the AlphaDev
# menu item 'Rebuild A Menu' to rebuild the WWW Menu.  This will enable the
# 'View Url' and related menu items and support procs.

if {[info tclversion] < 8.0} {
    set WWW::NoUrls 1
} else {
    set WWW::NoUrls 0
}

# ===========================================================================
#
#  WWW prefs, vars, arrays  #
# 

# To automatically 'float' a palette containing a rendered window's marks,
# turn this item on|| after To disable the automatic 'floating' of a palette
# containing a rendered window's marks, turn this item off
newPref flag autoFloatMarks         0 WWW
# To only open one WWW browser window at a time, turn this item on. 
# (Navigating bookmarks or history items will kill the current window)||To
# create a new window for every WWW browser page, turn this item off
newPref flag linksOpenNewWindow     0 WWW
# To automatically place the selected link in the center of the window when
# navigating up or down, turn this item on||To never automatically place
# the selected link in the center of the window when navigating up or down,
# turn this item on 
newPref flag centerRefreshOnNav     0 WWW
# To handle all 'ftp' links internally, turn this item
# on||To never handle any 'ftp' links internally, turn this item off
newPref flag ftpLinksInternal       0 WWW
# To fetch and parse all 'http' links using the WWW menu, turn this item
# on||To never send any fetch and parse all 'http' links using the WWW
# menu, turn this item off
newPref flag httpLinksInternal      1 WWW
# To ignore all forms while rendering, turn this item on||To insert 'form
# begins/end' markers when rendering forms, turn this item off
newPref flag ignoreForms            0 WWW
# To ignore all images while rendering, turn this item on||To insert 'image'
# markers when rendering files, turn this item off
newPref flag ignoreImages           0 WWW
# To send all 'mailto' links to Alpha's Eudora menu, turn this item on||To
# never send any 'mailto' links to Alpha's Eudora menu, turn this item off
newPref flag mailtoLinksInternal    0 WWW
# To send all 'java applets' links using the 'Java Viewer Sig', turn this
# item on||To never send any 'mailto' links to Alpha's Eudora menu, turn
# this item off
newPref flag runJavaAppletsDirectly 0 WWW
# To send all unrecognized links (or those turned off by the prefs above) to
# internet config, turn this item on||To never send any unrecognized link to
# internet config, turn this item off
newPref flag wwwSendRemoteLinks     0 WWW

set WWW::PrefsInMenu {
    linksOpenNewWindow
    centerRefreshOnNav
    autoFloatMarks
    ignoreForms
    ignoreImages
    (-)
    ftpLinksInternal
    httpLinksInternal
    mailtoLinksInternal
    runJavaAppletsDirectly
    wwwSendRemoteLinks
}

# This local file or remote url will be opened by the "Home Page" menu item.\
newPref url homePage "" WWW

if {[set alpha::platform] == "tk"} {
    newPref url homePage "http://www.santafe.edu/~vince/Alphatk.html" WWW    
} elseif {[info tclversion] > 8.0} {
    newPref url homePage "http://alpha.olm.net" WWW
} else {
    newPref url homePage [file::toUrl [file join $HOME Help "HTML Help" HTMLmanual.html]] WWW
}

# This is the maximum width used before wrapping text when rendering windows.
newPref var fillColumn             75 WWW

newPref sig javaViewerSig "WARZ"

if {[set alpha::platform] == "tk"} {
    # In Alphatk, shadow, outline, and bold all turn text blue, so they
    # aren't very useful as options here.
    set wwwHeaderStyles [list underline - normal]
    set wwwHeader1      "underline"
    set wwwHeader2      "underline"
    set wwwHeader3      "underline"
} else {
    set wwwHeaderStyles [list shadow outline bold underline italics - normal]
    set wwwHeader1      "outline"
    set wwwHeader2      "bold"
    set wwwHeader3      "underline"
}

newPref var header1Style $wwwHeader1 WWW "" $wwwHeaderStyles
newPref var header2Style $wwwHeader2 WWW "" $wwwHeaderStyles
newPref var header3Style $wwwHeader3 WWW "" $wwwHeaderStyles

unset wwwHeaderStyles wwwHeader1 wwwHeader2 wwwHeader3

newPref color header1Color     blue     WWW
newPref color header2Color     red      WWW
newPref color header3Color     red      WWW
newPref color linkColor        green    WWW
newPref color visitedLinkColor magenta  WWW

# Command double-clicking will send the highlighted text to this search
# engine.
newPref url searchUrl1 {http://www.google.com/search?q=} WWW
# Command double-clicking while pressing the "option" key will send the
# highlighted text to this search engine.
newPref url searchUrl2 {http://search.metacrawler.com/crawler?general=} WWW
# Command double-clicking while pressing the "control" key will send the
# highlighted text to this search engine.
newPref url searchUrl3 {http://www.altavista.com/sites/search/web?q=} WWW
# Command double-clicking while pressing the "shift" key will send the
# highlighted text to this search engine.
newPref url searchUrl4 {http://google.yahoo.com/bin/query?p=} WWW

# Alpha 7 can't handle these yet.
if {[set WWW::NoUrls]} {
    unset WWWmodeVars(httpLinksInternal)
    unset WWWmodeVars(searchUrl1)
    unset WWWmodeVars(searchUrl2)
    unset WWWmodeVars(searchUrl3)
    unset WWWmodeVars(searchUrl4)
    set   WWW::PrefsInMenu [lremove [set WWW::PrefsInMenu] httpLinksInternal]
} 

# Links, history vars

ensureset WWW::Pages        ""
ensureset WWW::PagePos      -1
ensureset WWW::Visited      ""
ensureset WWW::FileSource() [list ]
ensureset WWW::BaseUrl()    [list ]

ensureset WWW::History [list [mtime [now] short]]
prefs::modified WWW::History

# To perform a special action with a new URL type, add an array entry
# indicating the procedure to be called with the remainder of the URL. You
# must also add a global variable or modeVar as above so that the user can
# choose whether Alpha should handle that type via the given procedure.  If
# any of this fails, the URL is just given to Internet Config to deal with.
# Note that 'file' URL's are always handled internally.

ensureset WWW::UrlAction(mailto) "Mail::newEmailWindow"
ensureset WWW::UrlAction(ftp)    "WWW::ftpLink"
ensureset WWW::UrlAction(file)   "WWW::fileLink"
ensureset WWW::UrlAction(http)   "WWW::httpLink"
ensureset WWW::UrlAction(java)   "WWW::javaLink"
ensureset WWW::AlwaysInternal    [list file java]

# ===========================================================================
#
#  Html Style, Accent Elements  #
# 

array set WWW::HtmlToStyle {
    "B"         bold
    "I"         italic
    "U"         underline
    "BIG"       outline
    "SMALL"     condensed
    "EM"        italic
    "STRONG"    bold
}

array set WWW::HtmlToAccents {

    "#9"        {}
    "#32"       { }
    "#33"       {!}
    "#34"       {\"}
    "#35"       {\#}
    "#36"       {$}
    "#37"       {%}
    "#38"       {&}
    "#39"       {'}

    "#40"       {\(}
    "#41"       {\)}
    "#42"       {*}
    "#43"       {+}
    "#44"       {,}
    "#45"       {-}
    "#46"       {.}
    "#47"       {/}
    "#48"       {0}
    "#49"       {1}

    "#50"       {2}
    "#51"       {3}
    "#52"       {4}
    "#53"       {5}
    "#54"       {6}
    "#55"       {7}
    "#56"       {8}
    "#57"       {9}
    "#58"       {:}
    "#59"       {;}

    "#60"       {<}
    "#61"       {=}
    "#62"       {>}
    "#63"       {?}
    "#64"       {@}
    "#65"       {A}
    "#66"       {B}
    "#67"       {C}
    "#68"       {D}
    "#69"       {E}

    "#70"       {F}
    "#71"       {G}
    "#72"       {H}
    "#73"       {I}
    "#74"       {J}
    "#75"       {K}
    "#76"       {L}
    "#77"       {M}
    "#78"       {N}
    "#79"       {O}

    "#80"       {P}
    "#81"       {Q}
    "#82"       {R}
    "#83"       {S}
    "#84"       {T}
    "#85"       {U}
    "#86"       {V}
    "#87"       {W}
    "#88"       {X}
    "#89"       {Y}

    "#90"       {Z}
    "#91"       {\[}
    "#92"       {\\}
    "#93"       {\]}
    "#94"       {^}
    "#95"       {_}
    "#96"       {`}
    "#97"       {a}
    "#98"       {b}
    "#99"       {c}

    "#100"      {d}
    "#101"      {e}
    "#102"      {f}
    "#103"      {g}
    "#104"      {h}
    "#105"      {i}
    "#106"      {j}
    "#107"      {k}
    "#108"      {l}
    "#109"      {m}

    "#110"      {n}
    "#111"      {o}
    "#112"      {p}
    "#113"      {q}
    "#114"      {r}
    "#115"      {s}
    "#116"      {t}
    "#117"      {u}
    "#118"      {v}
    "#119"      {w}

    "#120"      {x}
    "#121"      {y}
    "#122"      {z}
    "#123"      {{}
    "#124"      {|}
    "#125"      {}}
    "#126"      {~}
    "#127"      {}

    "#130"      {}
    "#131"      {}
    "#132"      {}
    "#133"      {}
    "#134"      {}
    "#135"      {}
    "#136"      {}
    "#137"      {}
    "#138"      {?}
    "#139"      {}

    "#145"      {} 
    "#146"      {} 
    "#147"      {} 
    "#148"      {} 
    "#149"      {} 

    "#150"      {} 
    "#151"      {} 
    "#152"      {} 
    "#153"      {} 
    "#154"      {?} 
    "#155"      {} 
    "#156"      {} 
    "#159"      {}

    "#160"	{ }
    "#161"	{}
    "#162"	{}
    "#163"	{}
    "#164"	{?}
    "#165"	{}
    "#166"	{|}
    "#167"	{}
    "#168"	{}
    "#169"      {}

    "#170"	{}
    "#171"	{}
    "#172"	{}
    "#175"	{}
    "#176"	{}
    "#177"	{}

    "#180"	{}
    "#181"	{}
    "#182"	{}
    "#183"	{}
    "#184"	{}
    "#186"	{}
    "#187"	{}

    "#191"	{}
    "#247"	{}
    "#338"	{}
    "#339"	{}
    "#376"	{}
    "#402"	{}

    "#8211"	{}
    "#8212"	{}
    "#8216"	{}
    "#8217"	{}
    "#8218"	{}
    "#8220"	{}
    "#8221"	{}
    "#8222"	{}
    "#8224"	{}
    "#8225"	{}
    "#8226"	{}
    "#8230"	{}
    "#8240"	{}
    "#8249"	{}
    "#8250"	{}
    "#8482"	{}
    "#8730"	{}
    "#8734"	{}
    "#8747"	{}
    "#8776"	{}
    "#8800"	{}
    "#8804"	{}
    "#8805"	{}

    "aacute"	{}
    "Aacute"	{}
    "acirc"	{}
    "Acirc"	{}
    "aelig"	{}
    "AElig"	{}
    "agrave"	{}
    "Agrave"	{}
    "aring"	{}
    "Aring"	{}
    "atilde"	{}
    "Atilde"	{}
    "auml"	{}
    "Auml"	{}
    "ccedil"	{}
    "Ccedil"	{}
    "copy"	{}
    "eacute"	{}
    "Eacute"	{}
    "ecirc"	{}
    "Ecirc"	{}
    "Euml"	{}
    "egrave"	{}
    "Egrave"	{}
    "euml"	{}
    "gt"	{>}
    "iacute"	{}
    "Iacute"	{}
    "icirc"	{}
    "Icirc"	{}
    "igrave"	{}
    "Igrave"	{}
    "iuml"	{}
    "Iuml"	{}
    "lt"	{<}
    "nbsp"	{ }
    "ntilde"	{}
    "Ntilde"	{}
    "oacute"	{}
    "Oacute"	{}
    "ocirc"	{}
    "Ocirc"	{}
    "ograve"	{}
    "Ograve"	{}
    "oslash"	{}
    "Oslash"	{}
    "otilde"	{}
    "Otilde"	{}
    "ouml"	{}
    "Ouml"	{}
    "quot"	{"}
    "reg"	{}
    "szlig"	{}
    "uacute"	{}
    "Uacute"	{}
    "ucirc"	{}
    "Ucirc"	{}
    "ugrave"	{}
    "Ugrave"	{}
    "uuml"	{}
    "Uuml"	{}
    "yuml"	{}
}

# ===========================================================================
# 
#  Bindings  #
# 
# Bind various keys to imitate lynx.
# 
#  +++ Keystroke Commands	+++
# 
#  MOVEMENT:  Down arrow	- Highlight next topic
#             Up arrow	        - Highlight previous topic
#             Right arrow	- Jump to highlighted topic
#             Return, Enter	- Jump to highlighted topic
#             Left arrow	- Return to previous topic
# 
#  SCROLLING: +                 - Scroll down to next page (Page-Down)
#             -                 - Scroll up to previous page (Page-Up)
#             SPACE             - Scroll down to next page (Page-Down)
#             b                 - Scroll up to previous page (Page-Up)
#             CTRL-A            - Go to first page of the current document (Home)
#             CTRL-E            - Go to last page of the current document (End)
#             CTRL-B            - Scroll up to previous page (Page-Up)
#             CTRL-F            - Scroll down to next page (Page-Down)
#             CTRL-N            - Go forward two lines in the current document
#             CTRL-P            - Go back two lines in the current document
#             )                 - Go forward half a page in the current document
#             (                 - Go back half a page in the current document

Bind  'a'       {WWW::navigationProc bookmarks addBookmark} WWW
Bind  'b'       {WWW::navigationProc goToPage back}         WWW
Bind  'c'       {WWW::menuProc "" copyLinkLocation}         WWW
Bind  'e'       {WWW::menuProc "" editLinkedDocument}       WWW
Bind  'f'       {WWW::navigationProc goToPage forward}      WWW
Bind  'g'       {WWW::navigationProc goToPage ""}           WWW
Bind  'r'       {WWW::menuProc "" reload}                   WWW
Bind  'h'       {WWW::menuProc "" history}                  WWW
Bind  'h' <c>   {WWW::menuProc "" home}                     WWW
Bind  'o'       {WWW::menuProc "" openSourceInAlpha}        WWW
Bind  's'       {WWW::menuProc "" sendSourceToBrowser}      WWW
Bind  's' <c>   {WWW::menuProc "" saveSourceFileAs}         WWW
Bind  'v'       {WWW::renderUrl}                            WWW

Bind 0x73 <c>   {WWW::menuProc "" home}                     WWW
Bind 0x24 <z>   {WWW::menuProc "" modifyLink}               WWW
Bind 0x24 <o>   {WWW::menuProc "" editLinkedDocument}       WWW
Bind 0x24 <s>   {WWW::menuProc "" linkInNewWindow}          WWW
Bind 0x24 <zs>  {WWW::menuProc "" linkToBrowser}            WWW

Bind Home       {WWW::navigationProc "" Home}               WWW
Bind  'a' <z>   {WWW::navigationProc "" Home}               WWW
Bind End        {WWW::navigationProc "" End}                WWW
Bind  'e' <z>   {WWW::navigationProc "" End}                WWW

Bind 0x79       {WWW::navigationProc "" PageForward}        WWW
Bind 0x31       {WWW::navigationProc "" PageForward}        WWW
Bind  '+'       {WWW::navigationProc "" PageForward}        WWW
Bind 0x74       {WWW::navigationProc "" PageBack}           WWW
Bind  '-'       {WWW::navigationProc "" PageBack}           WWW

Bind  'n' <z>   {WWW::navigationProc "" twoLinesForward}    WWW
Bind  'p' <z>   {WWW::navigationProc "" twoLinesBack}       WWW
Bind  ')'       {WWW::navigationProc "" halfPageForward}    WWW
Bind  '('       {WWW::navigationProc "" halfPageBack}       WWW

Bind 0x7b       {WWW::navigationProc goToPage back}         WWW
Bind '\[' <c>   {WWW::navigationProc goToPage back}         WWW

Bind 0x7c       {WWW::link}                                 WWW
Bind '\]' <c>   {WWW::navigationProc goToPage forward}      WWW

Bind  '\t'      {WWW::navigationProc "" down}               WWW
Bind 0x7d       {WWW::navigationProc "" down}               WWW

Bind 0x7e       {WWW::navigationProc "" up}                 WWW

Bind 0x24       {WWW::link}                                 WWW
Bind 0x34       {WWW::link}                                 WWW

#  More mode stuff  #

proc WWW::DblClick {from to shift option control} {
    
    global WWW::NoUrls
    
    if {[set WWW::NoUrls]} {
        status::msg "Command double click is not yet implemented."
	return
    } 
    
    global WWWmodeVars
    
    if {![catch {WWW::getCurrentLink} result]} {
	WWW::link [lindex $result 3]
    } else {
	select $from $to
	set text [getSelect]
	# Any modifiers pressed?
	if {$option} {
	    WWW::searchProc "" wwwSearch2 $text
	} elseif {$control} {
	    WWW::searchProc "" wwwSearch3 $text
	} elseif {$shift} {
	    WWW::searchProc "" wwwSearch4 $text
	} else {
	    WWW::searchProc "" wwwSearch1 $text
	} 
    }
}

# Marks should be set be whatever proc is creating a WWW window, and
# then store them in a WWW::Marks cache.  This is simply to avoid the
# annoyance of wiping out the set of marks previously set.

proc WWW::MarkFile {} {
    
    global WWW::Marks
    
    set title [win::Current]
    if {[info exists WWW::Marks($title)]} {
	set count 0
        foreach markPos [set WWW::Marks($title)] {
	    eval setNamedMark $markPos
	    incr count
	}
	if {$count == "1"} {
	    status::msg "'$title' contains $count mark."
	} else {
	    status::msg "'$title' contains $count marks."
	}
    } else {
        status::msg "No marks found in '$title'."
    }
}

proc WWW::parseFuncs {} {

    global WWW::Links
    
    set results [list ]
    if {[win::Current] == "* WWW History *"} {
	set pos [minPos]
	set pat "\" \-\-\[\r\n\]+"
	while {![catch {search -s -f 1 -r 1 -i 0 $pat $pos} match]} {
	    set pos0 [lineStart [lindex $match 0]]
	    set pos1 [pos::math [lindex $match 1] - 1]
	    set name [string trim [string trim [getText $pos0 $pos1] {\" --}]]
	    lappend results [list $name $pos0]
	    set pos [nextLineStart [lindex $match 1]]
	}
    } else {
        foreach linkList [set WWW::Links([win::Current])] {
	    set pos0 [lindex $linkList 0] 
	    set pos1 [lindex $linkList 1] 
	    set name [win::MakeTitle [getText $pos0 $pos1]]
	    lappend results [list $name $pos0]
	}
    }
    return [join [lsort -ignore $results]]
}

# ===========================================================================
# 
# .